program DemoRTTI;

uses
  RTTI, uDemoRTTI, System.SysUtils, TypInfo;

var
  Kontekst: TRTTIContext;
  TypTymcz: TRttiType;
  PoleTymcz: TRttiField;
  WłaściwośćTymcz: TRttiProperty;
  WłaściwośćIndTymcz: TRttiIndexedProperty;
  MetodaTymcz: TRttiMethod;
  ParametryTymcz: TArray<TRttiParameter>;
  ParametrTymcz: TRttiParameter;
  NowaWartość: TValue;
  KDR: KlasaDemoRTTI;

procedure WywołanieMetodyZaPomocąRTTI;
var
  KDR: KlasaDemoRTTI;
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  MetodaTymcz: TRttiMethod;
  ParametryTymcz: TArray<TRttiParameter>;
  ParametrTymcz: TRttiParameter;
  TymczWartość: TValue;
  TymczWynik: TValue;
  WartościParametrów: array[0..1] of TValue;
  i: Integer;
begin
  KDR := KlasaDemoRTTI.Create;
  try
    TypTymcz := Kontekst.GetType(KlasaDemoRTTI);
    for MetodaTymcz in TypTymcz.GetDeclaredMethods do
    begin
      // Pominięcie konstruktora i analiza tylko metod publicznych
      if (MetodaTymcz.Visibility <> mvPublic) then Continue;
      if MetodaTymcz.IsConstructor then Continue;
      WriteLn('Wywołanie metody o nazwie: ', MetodaTymcz.Name);
      case MetodaTymcz.MethodKind of
        mkProcedure: begin
                       ParametryTymcz := MetodaTymcz.GetParameters;
                       // Znamy parametry...
                       i := 0;

                       case Length(ParametryTymcz) of
                         0: MetodaTymcz.Invoke(KDR, []);
                         1: MetodaTymcz.Invoke(KDR, [0]);
                         2: begin
                              for ParametrTymcz in ParametryTymcz do
                              begin
                                case ParametrTymcz.ParamType.TypeKind of
                                  tkString,
                                  tkUString: TymczWartość := 'Parametry przekazane przez Invoke';
                                  tkFloat: TymczWartość := 3.14159;
                                  tkInteger: TymczWartość := 0;
                                end;
                                WartościParametrów[i] := TymczWartość;
                                inc(i);
                              end;

                              MetodaTymcz.Invoke(KDR, [WartościParametrów[0], WartościParametrów[1]]);
                            end;
                       end;
                     end;
        mkFunction: begin
                      // Pominięcie metod odczytujących właściwości
                      if not UpperCase(MetodaTymcz.Name).Contains('GET') then
                      begin
                        TymczWynik := MetodaTymcz.Invoke(KDR, []);
                        WriteLn('Wynik wywołania metody ', MetodaTymcz.Name, ': ',
                          TymczWynik.ToString);
                      end;
                    end;
      else
        Continue;
      end;
    end;
  finally
    KDR.Free;
  end;
end;


begin
  TypTymcz := Kontekst.GetType(KlasaDemoRTTI.ClassInfo);

  // Pola
  WriteLn(TypTymcz.Name, ' zawiera następujące pola: ');
  for PoleTymcz in TypTymcz.GetFields do
  begin
    WriteLn(' ', PoleTymcz.ToString, ' o widoczności: ',
      GetEnumName(TypeInfo(TMemberVisibility),
        Integer(PoleTymcz.Visibility)));
  end;

  // Właściwości
  WriteLn(TypTymcz.Name, ' zawiera następujące właściwości:');
  for WłaściwośćTymcz in TypTymcz.GetProperties do
  begin
    WriteLn(' ', WłaściwośćTymcz.ToString, ' o widoczności: ',
      GetEnumName(TypeInfo(TMemberVisibility),
        Integer(WłaściwośćTymcz.Visibility)));
  end;

  // Właściwości indeksowane
  WriteLn(TypTymcz.Name, ' zawiera następujące właściwości indeksowane:');
  for WłaściwośćIndTymcz in TypTymcz.GetIndexedProperties do
  begin
    WriteLn(' ', WłaściwośćIndTymcz.ToString, ' o widoczności: ',
      GetEnumName(TypeInfo(TMemberVisibility),
        Integer(WłaściwośćIndTymcz.Visibility)));
  end;

  // Metody
  WriteLn(TypTymcz.Name, ' zawiera następujące metody:');
  for MetodaTymcz in TypTymcz.GetDeclaredMethods do
  begin
    WriteLn(' ', MetodaTymcz.Name);
    ParametryTymcz := MetodaTymcz.GetParameters;
  if Length(ParametryTymcz) > 0 then
  begin
    for ParametrTymcz in ParametryTymcz do
    begin
      WriteLn(' ', ParametrTymcz.ToString);
    end;
    end else
    begin
      WriteLn(' ', 'brak parametrów');
    end;
  end;

  KDR := KlasaDemoRTTI.Create;
  WriteLn('Odczytywanie i nadawanie wartości pola prywatnego...');
  TypTymcz := Kontekst.GetType(KlasaDemoRTTI.ClassInfo);
  PoleTymcz := TypTymcz.GetField('FPolePrywatne');
  NowaWartość := 'To jest nowa wartość pola FPolePrywatne zapisana w zamiennej typu TValue';
  PoleTymcz.SetValue(KDR, NowaWartość);
  WriteLn('Wartość tę można odczytać za pomoca RTTI: ', PoleTymcz.GetValue(KDR).ToString);

  WriteLn('Odczytywanie i nadawanie wartości właściwości...');
  WłaściwośćTymcz := TypTymcz.GetProperty('WłaściwośćPubliczna');
  NowaWartość := 'Nowa wartość WłaściwośćPubliczna';
  WłaściwośćTymcz.SetValue(KDR, NowaWartość);
  WriteLn('WłaściwośćPubliczna ma teraz wartość: ', KDR.WłaściwośćPubliczna);
  WriteLn('Wartpość tę można też odczytać za pomocą RTTI: ', WłaściwośćTymcz.GetValue(KDR).ToString);

  WłaściwośćIndTymcz := TypTymcz.GetIndexedProperty('WłaściwośćIndeksowana');
  NowaWartość := 'To jest indeks 0';
  WłaściwośćIndTymcz.SetValue(KDR, [0], NowaWartość);
  NowaWartość := 'To jest indeks 1';
  WłaściwośćIndTymcz.SetValue(KDR, [1], NowaWartość);
  WriteLn('WłaściwośćIndeksowana[0] odczytana za pomocą RTTI: ',
    WłaściwośćIndTymcz.GetValue(KDR, [0]).ToString);
  WriteLn('WłaściwośćIndeksowana[1] odczytana bezpośrednio z instancji: ',
    KDR.WłaściwośćIndeksowana[1]);
  KDR.Free;

  WywołanieMetodyZaPomocąRTTI;
  ReadLn;
end.
